/*
 * Decompiled with CFR 0.152.
 */
package inettools;

import inettools.Irc;
import inettools.IrcConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import lib.Utils.Utils;

public class SocketIrc
extends IrcConnection {
    private int bytein;
    private int byteout;
    private boolean connected;
    private StreamConnection connector;
    private String encoding;
    private DataInputStream in;
    private DataOutputStream out;
    private String outbuf;

    public SocketIrc(String charset) {
        this.encoding = charset;
        this.bytein = 0;
        this.byteout = 0;
        this.connected = false;
    }

    public String connect(String host, int port, String init) {
        String ret = null;
        try {
            this.connector = (StreamConnection)Connector.open((String)("socket://" + host + ":" + port), (int)3);
            this.in = this.connector.openDataInputStream();
            this.out = this.connector.openDataOutputStream();
            this.outbuf = null;
            this.connected = true;
            ret = this.writeData(init);
        }
        catch (Exception e) {
            ret = Irc.language.get("errorconnecting");
            ret = ret + Irc.language.get("exception") + ": " + e.getMessage();
            return ret;
        }
        return null;
    }

    public void disconnect() {
        if (this.connected) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            this.in = null;
            this.out = null;
            this.connector = null;
            this.connected = false;
        }
    }

    public int getBytesIn() {
        return this.bytein;
    }

    public int getBytesOut() {
        return this.byteout;
    }

    public boolean hasDataInBuffer() {
        try {
            return this.in.available() > 0;
        }
        catch (IOException e) {
            return this.connected;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String readLine() {
        String ret = null;
        try {
            byte[] buf = Utils.readLine(this.in);
            if (buf == null) {
                return null;
            }
            this.bytein += buf.length + 40;
            ret = this.byteArrayToString(buf, this.encoding);
        }
        catch (Exception e) {
            this.connected = false;
        }
        return ret;
    }

    public String updateConnection() {
        if (this.outbuf != null && this.connected) {
            try {
                byte[] tmp = this.stringToByteArray(this.outbuf, this.encoding);
                this.outbuf = null;
                this.out.write(tmp);
                this.out.flush();
                this.byteout += tmp.length;
            }
            catch (Exception e) {
                String ret = Irc.language.get("socketioerror");
                ret = ret + Irc.language.get("Exception") + ": " + e.getMessage();
                this.connected = false;
                return ret;
            }
        }
        return null;
    }

    public String writeData(String input) {
        this.outbuf = this.outbuf == null ? input : this.outbuf + input;
        return this.updateConnection();
    }
}

